<?php

namespace Import\ApiBundle\Services\Import;


class ImportInterest extends ImportMainService
{
    protected $url = 'http://www.wskazniki.pl/?doc_id=280156&iid=4637';

    protected $columns = array("Okres","Value");

    public function import()
    {
        $this->type = 'ImportInterest';
        $data = $this->getTableFromPage($this->url,$this->columns);

        foreach($data as $id => $row)
        {
            if($this->validRow($row))
            {
                $row = $this->addDataToRow($row);
                if(empty($row))
                {
                    $this->addError(3,$data[$id],$this->type);
                    unset($data[$id]);
                }
                else
                {
                    $data[$id] = $row;
                }
            }
            else
            {
                unset($data[$id]);
            }
        }
        $count = $this->save($data);
        $this->viewErrors();

        return array('count' => $count);
    }

    protected function validRow($row)
    {
        $valid = true;

        foreach($this->columns as $column)
        {
            if(!isset($column) || $row[$column] == '')
            {
                $valid = false;
                $this->addError(1,$column,$this->type);
            }
        }

        return $valid;
    }

    protected function addDataToRow($row)
    {
        $data = $row[$this->columns[0]];
        $data = str_replace('od','',$data);
        $data = str_replace('r.','',$data);
        $data = str_replace('za','',$data);
        $data = str_replace('dzień','',$data);
        $data = trim($data);

        $dataArray = explode(' ',$data);

        if(count($dataArray) != 3)
        {
            return false;
        }

        $DataTime = $this->createDataFromArray($dataArray);

        if(!$DataTime)
        {
            $this->addError(2,$row[$this->columns[0]],$this->type);
            return false;
        }
        $row['DataFrom'] = $DataTime;

        $row[$this->columns[1]] = trim($row[$this->columns[1]]);
        $row[$this->columns[1]] = str_replace(',','.',$row[$this->columns[1]]);

        return $row;
    }

    protected function save($data)
    {
        $data = array_reverse($data);
        $LastInterest = $this->getDoctrine()->getRepository('ImportApiBundle:Interest')->getLastInterest();

        $i = 0;
        foreach($data as $row)
        {
            if(empty($LastInterest) || $row['DataFrom'] > $LastInterest->getDataFrom())
            {
                if(!empty($LastInterest))
                {
                    $dateYesterday = clone $row['DataFrom'];
                    $dateYesterday->modify('-1 day');
                    $LastInterest->setDataTo($dateYesterday);
                    $this->getDoctrine()->getEntityManager()->persist($LastInterest);
                }
                $LastInterest = $this->getDoctrine()->getRepository('ImportApiBundle:Interest')->add($row);
                $i++;
            }
        }
        $this->getDoctrine()->getEntityManager()->flush();

        return $i;
    }
}